/*
 * Decompiled with CFR 0.152.
 */
package com.InitialImmortal.initial.event;

import com.InitialImmortal.initial.helper.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class OpenItemStorageSpace {
    @SubscribeEvent
    public static void onOpenItemStorageSpace(PlayerInteractEvent event) {
        if (event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        if (!(event.getEntityPlayer() instanceof EntityPlayerMP)) {
            return;
        }
        final ItemStack itemStack = event.getItemStack();
        NBTTagCompound nbtTagCompound = NBTHelper.saveNBT(itemStack.func_77978_p());
        NBTTagCompound tagCompound = nbtTagCompound.func_74775_l("itemContainer");
        boolean has = nbtTagCompound.func_74767_n("hasContainer");
        if (has) {
            int line = nbtTagCompound.func_74762_e("line");
            String name = nbtTagCompound.func_74779_i("name");
            InventoryBasic inventoryBasic = new InventoryBasic(name, true, line * 9);
            NBTTagList tagList = tagCompound.func_150295_c("Items", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTags = tagList.func_150305_b(i);
                int slot = itemTags.func_74762_e("Slot");
                if (slot < 0 || slot >= inventoryBasic.func_70302_i_()) continue;
                inventoryBasic.func_70299_a(slot, new ItemStack(itemTags));
            }
            nbtTagCompound.func_74757_a("isOpen", true);
            itemStack.func_77982_d(nbtTagCompound);
            ContainerChest containerChest = new ContainerChest((IInventory)event.getEntityPlayer().field_71071_by, (IInventory)inventoryBasic, event.getEntityPlayer()){

                public void func_75134_a(EntityPlayer playerIn) {
                    NBTTagCompound compound = itemStack.func_77978_p();
                    if (compound != null) {
                        compound.func_82580_o("isOpen");
                        itemStack.func_77982_d(compound);
                    }
                }
            };
            OpenItemStorageSpace.displayGUIChest((EntityPlayerMP)event.getEntityPlayer(), containerChest, name);
        }
    }

    private static void displayGUIChest(EntityPlayerMP player, ContainerChest iInventory, String name) {
        player.func_71117_bO();
        TextComponentString windowTitleIn = new TextComponentString(name);
        player.field_71135_a.func_147359_a((Packet)new SPacketOpenWindow(player.field_71139_cq, iInventory.func_85151_d().func_70005_c_(), (ITextComponent)windowTitleIn, iInventory.func_85151_d().func_70302_i_()));
        player.field_71070_bA = iInventory;
        player.field_71070_bA.field_75152_c = player.field_71139_cq;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
    }
}

